Imports System.Drawing

Public Class Form1
  Inherits System.Windows.Forms.Form

#Region " Windows Form Designer generated code "

  Public Sub New()
    MyBase.New()

    'This call is required by the Windows Form Designer.
    InitializeComponent()

    'Add any initialization after the InitializeComponent() call

  End Sub

  'Form overrides dispose to clean up the component list.
  Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
    If disposing Then
      If Not (components Is Nothing) Then
        components.Dispose()
      End If
    End If
    MyBase.Dispose(disposing)
  End Sub
  Friend WithEvents ComboBox1 As System.Windows.Forms.ComboBox
  Friend WithEvents Label1 As System.Windows.Forms.Label
  Friend WithEvents Label2 As System.Windows.Forms.Label
  Friend WithEvents ComboBox2 As System.Windows.Forms.ComboBox
  Friend WithEvents Panel1 As System.Windows.Forms.Panel

  'Required by the Windows Form Designer
  Private components As System.ComponentModel.Container

  'NOTE: The following procedure is required by the Windows Form Designer
  'It can be modified using the Windows Form Designer.  
  'Do not modify it using the code editor.
  <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
    Me.ComboBox2 = New System.Windows.Forms.ComboBox()
    Me.ComboBox1 = New System.Windows.Forms.ComboBox()
    Me.Label1 = New System.Windows.Forms.Label()
    Me.Label2 = New System.Windows.Forms.Label()
    Me.Panel1 = New System.Windows.Forms.Panel()
    Me.SuspendLayout()
    '
    'ComboBox2
    '
    Me.ComboBox2.DropDownWidth = 240
    Me.ComboBox2.Location = New System.Drawing.Point(128, 80)
    Me.ComboBox2.Name = "ComboBox2"
    Me.ComboBox2.Size = New System.Drawing.Size(240, 24)
    Me.ComboBox2.TabIndex = 3
    '
    'ComboBox1
    '
    Me.ComboBox1.DropDownWidth = 240
    Me.ComboBox1.Location = New System.Drawing.Point(128, 24)
    Me.ComboBox1.Name = "ComboBox1"
    Me.ComboBox1.Size = New System.Drawing.Size(240, 24)
    Me.ComboBox1.TabIndex = 0
    '
    'Label1
    '
    Me.Label1.Location = New System.Drawing.Point(16, 24)
    Me.Label1.Name = "Label1"
    Me.Label1.TabIndex = 1
    Me.Label1.Text = "Pick-a-Brush"
    '
    'Label2
    '
    Me.Label2.Location = New System.Drawing.Point(24, 88)
    Me.Label2.Name = "Label2"
    Me.Label2.Size = New System.Drawing.Size(80, 23)
    Me.Label2.TabIndex = 2
    Me.Label2.Text = "Pick-a-Pen"
    '
    'Panel1
    '
    Me.Panel1.Dock = System.Windows.Forms.DockStyle.Bottom
    Me.Panel1.Location = New System.Drawing.Point(0, 144)
    Me.Panel1.Name = "Panel1"
    Me.Panel1.Size = New System.Drawing.Size(680, 392)
    Me.Panel1.TabIndex = 4
    '
    'Form1
    '
    Me.AutoScaleBaseSize = New System.Drawing.Size(6, 15)
    Me.ClientSize = New System.Drawing.Size(680, 536)
    Me.Controls.AddRange(New System.Windows.Forms.Control() {Me.Panel1, Me.ComboBox2, Me.Label2, Me.Label1, Me.ComboBox1})
    Me.Name = "Form1"
    Me.Text = "Drawing Demo"
    Me.ResumeLayout(False)

  End Sub

#End Region

  Private Sub InitializeBrushList()
    Dim Information() As System.Reflection.PropertyInfo _
         = GetType(Brushes).GetProperties()

    Dim I As Integer
    For I = 0 To Information.Length - 1
      ComboBox1.Items.Add(Information(I).Name)
    Next
  End Sub

  Private Sub InitializePenList()
    Dim Information() As System.Reflection.PropertyInfo _
      = GetType(Pens).GetProperties

    Dim I As Integer
    For I = 0 To Information.Length - 1
      ComboBox2.Items.Add(Information(I).Name)
    Next

  End Sub

  Private Sub Initialize()
    InitializeBrushList()
    InitializePenList()
  End Sub

  Private Sub Form1_Load(ByVal sender As System.Object, _
    ByVal e As System.EventArgs) Handles MyBase.Load
		Initialize()
	End Sub

	Private Function GetLeft() As Single
		Return ComboBox1.Left + ComboBox1.Width + 10
	End Function

	Private Function GetTop() As Single
		Return Label1.Top
	End Function

	Private Function GetBrush() As Brush
		Return New SolidBrush(Color.FromName(ComboBox1.Text))
	End Function

	Private Function GetText() As String
		Return ComboBox1.Text
	End Function

	Private Sub ComboBox1_SelectedIndexChanged( _
		ByVal sender As System.Object, ByVal e As System.EventArgs) _
		Handles ComboBox1.SelectedIndexChanged

		Invalidate()
	End Sub

	Private Sub DrawBrush(ByVal Graphic As Graphics)
		Graphic.DrawString(GetText(), _
			New Font("Garamond", 16, FontStyle.Italic Or FontStyle.Bold), GetBrush(), GetLeft(), GetTop())

	End Sub

	Private Function GetPen() As Pen
		Return New Pen(Color.FromName(ComboBox2.Text), 2)
	End Function

	Private Sub DrawPen(ByVal Graphic As Graphics)
		Graphic.DrawEllipse(GetPen(), _
			New RectangleF(ComboBox2.Left + ComboBox2.Width + 10, ComboBox2.Top, _
				200, 60))
	End Sub

	Private Sub Form1_Paint(ByVal sender As Object, _
		ByVal e As System.Windows.Forms.PaintEventArgs) _
		Handles MyBase.Paint

		If (GetText() <> vbNullString) Then
			DrawBrush(e.Graphics)
		End If

		If (ComboBox2.Text <> vbNullString) Then
			DrawPen(e.Graphics)
		End If

	End Sub

	Private Sub ComboBox2_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ComboBox2.SelectedIndexChanged
		Invalidate()
	End Sub

	Private Function RandomRect( _
		Optional ByVal Max As Integer = 36) As RectangleF

		Static Count As Integer = 0
		Count += 1 : If (Count >= Max) Then Count = 0
		Return New RectangleF((Panel1.ClientRectangle.Width - (Count * 10)) / 2, 10, Count * 10, 300)

	End Function

	Private Sub Panel1_Paint(ByVal sender As Object, _
		ByVal e As System.Windows.Forms.PaintEventArgs) _
		Handles Panel1.Paint

		Const Max As Integer = 36
		Dim I As Integer
		For I = 1 To Max
			e.Graphics.DrawEllipse(Pens.Blue, RandomRect(Max))
		Next

	End Sub

	Private Sub Panel1_Resize(ByVal sender As Object, ByVal e As System.EventArgs) Handles Panel1.Resize
		Panel1.Invalidate()
	End Sub
End Class
